<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function umvapay_config() {
    return [
        "FriendlyName" => ["Type" => "System", "Value" => "UmvaPay 
Gateway"],
        "public_key" => ["FriendlyName" => "Public Key", "Type" => "text", 
"Size" => "50"],
        "secret_key" => ["FriendlyName" => "Secret Key", "Type" => "text", 
"Size" => "50"],
        "payment_mode" => ["FriendlyName" => "Payment Mode", "Type" => 
"dropdown", "Options" => "test,live"]
    ];
}

function umvapay_link($params) {
    $invoiceId = $params['invoiceid'];
    $amount = $params['amount'];
    $currency = $params['currency'];
    $clientEmail = $params['clientdetails']['email'];

    $publicKey = $params['public_key'];
    $paymentMode = $params['payment_mode'];
    $systemUrl = rtrim($params['systemurl'], '/');

    $endpoint = ($paymentMode == 'live') ? 
"https://pay.umva.net/payment/initiate" : 
"https://pay.umva.net/sandbox/payment/initiate";

    $callbackUrl = $systemUrl . 
'/modules/gateways/callback/umvapay.php?invoiceid=' . $invoiceId;
    $cancelUrl = $systemUrl . '/clientarea.php?action=invoices';
    $successUrl = $systemUrl . '/viewinvoice.php?id=' . $invoiceId;

    $parameters = [
        'identifier' => $publicKey,
        'currency' => $currency,
        'amount' => $amount,
        'details' => 'Invoice Payment #' . $invoiceId,
        'ipn_url' => $callbackUrl,
        'cancel_url' => $cancelUrl,
        'success_url' => $successUrl,
        'public_key' => $publicKey,
        'site_logo' => $systemUrl . '/assets/img/logo.png',
        'checkout_theme' => 'dark',
        'customer_name' => $params['clientdetails']['firstname'] . ' ' . 
$params['clientdetails']['lastname'],
        'customer_email' => $clientEmail,
    ];

    $form = '<form method="post" action="' . $endpoint . '" 
target="_blank">';
    foreach ($parameters as $key => $value) {
        $form .= '<input type="hidden" name="' . htmlspecialchars($key) . 
'" value="' . htmlspecialchars($value) . '">';
    }
    $form .= '<button type="submit">Pay with UmvaPay</button></form>';

    return $form;
}

function umvapay_refund($params) {
    return [
        'status' => 'error',
        'rawdata' => 'Refunds not supported by UmvaPay integration',
        'transid' => '',
        'fees' => 0,
    ];
}
